<?php
session_start();

// Registrar logout
if (isset($_SESSION['usuario_id'])) {
    require_once 'database.php';
    $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_SESSION['usuario_id'], 'logout', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
}

// Destruir sessão completamente
$_SESSION = array();

// Se deseja destruir o cookie, destrua também a sessão do cookie
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

session_destroy();

// Redirecionar para login
header("Location: login.php");
exit();
?>